<?php
header("Content-Type: text/html; charset=UTF-8");
session_start();
if (!isset($_SESSION['evaluator_name'])) {
    header("Location: register.php");
    exit();
}
$evaluatorName = $_SESSION['evaluator_name'];
include('last_db_config.php');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>تقييم الطلاب</title>
  <link rel="stylesheet" href="styles.css">
  <link rel="stylesheet" href="menu.css">
  <style>
    .controls, .counters { display: flex; gap: 20px; align-items: center; margin-bottom: 20px; flex-wrap: wrap; }
    .counters span { font-weight: bold; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { border: 1px solid #ccc; padding: 8px; text-align: center; }
    th { background: #f0f0f0; }
    .save-btn { padding: 5px 10px; background: #28a745; color: #fff; border: none; border-radius: 4px; cursor: pointer; }
    .save-btn:disabled { background: #aaa; cursor: default; }
    input[type=number] { width: 60px; }
    #saveMessage { margin-top: 10px; text-align: center; font-weight: bold; }
    
    .inputs-container {
  display: table-cell;
} 
    
    .topbar {
  background-color: #e0f7fa; /* لون سماوي ناعم */
  color: #004d40;
  padding: 10px 20px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  font-size: 18px;
  border-bottom: 2px solid #b2ebf2;
  font-weight: bold;
}

.topbar a {
  margin-left: 15px;
  text-decoration: none;
  color: #00695c;
  font-weight: bold;
  transition: color 0.3s;
}

.topbar a:hover {
  color: #004d40;
}

.welcome {
  font-size: 18px;
}
  
  </style>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="main-style.css">
</head>
<body>

  <header class="program-header">
    <div class="header-content">
      <img src="wezara.png" alt="شعار الوزارة" class="logo-right">
      <div class="title-container">
        <h1 class="program-title">البرنامج القومي لتنمية مهارات اللغة العربية بالحلقة الابتدائية</h1>
      </div>
      <img src="week.png" alt="شعار البرنامج" class="logo-left">
    </div>
    </header>


  <div class="topbar">
  <div class="welcome">مرحبًا د. <?= htmlspecialchars($evaluatorName) ?> 👋</div>
  <div class="topbar-links">
  <a href="#" onclick="location.reload()">🔄 تسجيل مدرسة جديدة</a>
    <a href="new_index.php">🚪 تسجيل خروج</a>
  </div>
</div>

  <div class="form-row1">
    <div class="form-group1">
      <label for="GovID">المحافظة</label>
      <select id="GovID" class="form-control1" required>
        <option disabled selected value="">اختر المحافظة</option>
        <?php
          $rs = mysqli_query($conn, "SELECT GovID, GovName FROM government ORDER BY GovName");
          while ($r = mysqli_fetch_assoc($rs)) {
            echo "<option value='{$r['GovID']}'>{$r['GovName']}</option>";
          }
        ?>
      </select>
    </div>
    <div class="form-group1">
      <label for="EdaraID">الإدارة التعليمية</label>
      <select id="EdaraID" class="form-control1" required>
        <option disabled selected>اختر الإدارة</option>
      </select>
    </div>
    
    <div class="form-group1">
      <label for="schoolID">المدرسة</label>
      <select id="schoolID" class="form-control1" required>
        <option disabled selected>اختر المدرسة</option>
      </select>
    </div>
    
    <div class="form-group1">
      <label for="classID">الصف</label>
      <select id="classID" class="form-control1" required>
        <option disabled selected>اختر الصف</option>
        <option value="3">الثالث</option>
        <option value="4">الرابع</option>
        <option value="5">الخامس</option>
        <option value="6">السادس</option>
      </select>
    </div>
  </div>
</div>

  <div class="counters">
    <span id="countEvaluated">✅ تم تقييم: 0</span>
    <span id="countNotEvaluated">🕒 لم يُقيم: 0</span>
  </div>

  <div id="studentsTableContainer"></div>
  <div id="saveMessage"></div>

<script>
$(function(){
  $('#GovID').change(function(){
    $.post('action copy.php',{GovID:$(this).val()}, data => {
      $('#EdaraID').html(data);
      $('#schoolID').html('<option disabled selected>اختر المدرسة</option>');
    });
  });

  $('#EdaraID').change(function(){
    $.post('action copy.php',{EdaraID:$(this).val()}, data => {
      $('#schoolID').html(data);
    });
  });

  $('#schoolID, #classID').change(buildTable);

  function buildTable(){
    const school = $('#schoolID').val(),
          cls    = $('#classID').val();
    if(!school || !cls) {
      $('#studentsTableContainer').html('<p style="color:red">يرجى اختيار المدرسة والصف</p>');
      return;
    }

    $('#studentsTableContainer').html('<p>جاري التحميل...</p>');
    $.post('fail_students_retrieve.php', { SchoolID: school, Class: cls }, res => {
      $('#countEvaluated').text('✅ تم تقييم: ' + res.evaluated);
      $('#countNotEvaluated').text('🕒 لم يُقيم: ' + res.notEvaluated);

      if(res.options.length === 0){
        $('#studentsTableContainer').html('<p>لا يوجد طلاب بحاجة للتقييم</p>');
        return;
      }

      let html = '<table><thead><tr><th>اسم الطالب</th>';
for(let i=1;i<=13;i++) html += `<th>السؤال${i}</th>`;
html += '<th>إجراء</th></tr></thead><tbody>';

res.options.forEach(stu => {
  html += `<tr data-id="${stu.StudentID}">`;

  // عمود اسم الطالب + الحضور والغياب
  html += `<td>
    <span style="color:red; font-weight:bold;">${stu.Name}<br>
    <span style="color:black; font-weight:bold;"><label><input type="radio" name="status_${stu.StudentID}" value="present" checked> حاضر</label>
    <label><input type="radio" name="status_${stu.StudentID}" value="absent"> غائب</label>
     </span><br>

  <label style="color:blue; font-weight:bold;">
    <input type="checkbox" class="merge-checkbox"> دمج
  </label>

  <br>
  <select class="disability-type" disabled style="margin-top:5px;">
    <option value="">اختر نوع الإعاقة</option>
    <option value="سمعية">سمعية</option>
    <option value="بصرية">بصرية</option>
    <option value="ذهنية">ذهنية</option>
    <option value="حركية">حركية</option>
  </select>
</td>`;
  // إدخال الدرجات - كل درجة في <td> منفصل
  for(let i=1;i<=13;i++){
    const max = i === 7 ? 3 : i === 8 || i === 10 ? 2 : i === 11 ? 3 : i === 13 ? 10 : 5;
    html += `<td class="inputs-container"><input type="number" name="grade${i}[]" min="0" max="${max}" class="grade-input" style="width:60px;"></td>`;
  }

  // زر الحفظ في عمود مستقل
  html += `<td><button class="save-btn">حفظ</button></td></tr>`;
});

html += '</tbody></table>';
$('#studentsTableContainer').html(html);
    }, 'json');
  }

  $(document).on('click','.save-btn', function(){
    const $row = $(this).closest('tr');
    const id   = $row.data('id');
    const data = { 
  student_id: id, 
  name: <?= json_encode($evaluatorName) ?>,
  merge: $row.find('.merge-checkbox').is(':checked') ? 1 : 0,
  disability: $row.find('.disability-type').val() || ''
};

    // تحقق إذا الطالب غائب
    if ($row.find('input[type=radio]:checked').val() === 'absent') {
      data.absent = true;
    } else {
      let allFilled = true;
      $row.find('input[type=number]').each(function(i){
        const val = $(this).val();
        if(val === '' || isNaN(val)) allFilled = false;
        data['q'+(i+1)] = val || 0;
      });
      if (!allFilled) {
        alert('يرجى إدخال جميع الدرجات قبل الحفظ.');
        return;
      }
    }

    const $btn = $(this);
    $btn.prop('disabled', true);

    $.post('insert_fail_student.php', data, response => {
      if(response.includes('success')){
        $row.remove();
        $('#saveMessage').css('color','green').text('✅ تم حفظ درجات الطالب ' + id);
        buildTable(); // تحديث العدادات
      } else {
        $('#saveMessage').css('color','red').text('❌ خطأ: ' + response);
        $btn.prop('disabled', false); // إعادة تفعيل الزر عند الخطأ
      }
    });
  });

  $(document).on('input click','#studentsTableContainer', () => {
    $('#saveMessage').text('');
  });

  $(document).on('input', '#studentsTableContainer input[type="number"]', function() {
    const max = parseInt($(this).attr('max'));
    const min = parseInt($(this).attr('min'));
    const val = parseInt($(this).val());

    if (val > max) $(this).val(max);
    else if (val < min || isNaN(val)) $(this).val('');
  });

  $(document).on('change', 'input[type=radio]', function() {
  const $row = $(this).closest('tr');
  if ($(this).val() === 'absent') {
    $row.find('.inputs-container').hide();
    $row.find('.save-btn').hide(); // ✅ إخفاء زر الحفظ
  } else {
    $row.find('.inputs-container').show();
    $row.find('.save-btn').show(); // ✅ إظهار زر الحفظ
  }
});
// عند اختيار أو إلغاء اختيار "دمج"
$(document).on('change', '.merge-checkbox', function() {
  const $row = $(this).closest('tr');
  const $disSelect = $row.find('.disability-type');

  if ($(this).is(':checked')) {
    $disSelect.prop('disabled', false);
  } else {
    $disSelect.prop('disabled', true).val('');
  }
});

});
</script>
</body>
</html>
